﻿using System.Windows;
using System.Windows.Browser;
using System.Windows.Controls;

namespace SilverlightScript
{
    public partial class MainPage : UserControl
    {
        public MainPage()
        {
            InitializeComponent();
        }

        private void OldClick(object sender, RoutedEventArgs e)
        {
            // Listing 18-8. Korzystanie z funkcji JavaScript w języku C# 3.0
            ScriptObject showMessage = (ScriptObject)
                HtmlPage.Window.GetProperty("showMessage");
            showMessage.InvokeSelf("Witaj, świecie");

            // Lub...

            ScriptObject window = HtmlPage.Window;
            window.Invoke("showMessage", "Witaj, świecie");
        }

        private void NewClick(object sender, RoutedEventArgs e)
        {
            // Listing 18-9. Korzystanie z funkcji JavaScript w języku C# 4.0
            dynamic window = HtmlPage.Window;
            window.showMessage("Witaj, świecie");
        }
    }
}
